/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.builtin;

import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.ExperienceSource;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.experience.calculation.condition.DamageTypeCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.DamageTypeTagCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.EntityTypeCondition;
import net.puffish.skillsmod.api.experience.calculation.condition.EntityTypeTagCondition;
import net.puffish.skillsmod.api.experience.calculation.parameter.EffectParameter;
import net.puffish.skillsmod.api.experience.calculation.parameter.ParameterFactory;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.experience.calculation.CalculationManager;

public class TakeDamageExperienceSource
implements ExperienceSource {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("take_damage");
    private static final Map<String, ConditionFactory<Context>> CONDITIONS = Map.ofEntries(Map.entry("damage_type", DamageTypeCondition.factory().map(c -> c.map(Context::damageType))), Map.entry("damage_type_tag", DamageTypeTagCondition.factory().map(c -> c.map(Context::damageType))), Map.entry("attacker", EntityTypeCondition.factory().map(c -> ctx -> ctx.attacker().map(c::test).orElse(false))), Map.entry("attacker_tag", EntityTypeTagCondition.factory().map(c -> ctx -> ctx.attacker().map(c::test).orElse(false))), Map.entry("source", EntityTypeCondition.factory().map(c -> ctx -> ctx.source().map(c::test).orElse(false))), Map.entry("source_tag", EntityTypeTagCondition.factory().map(c -> ctx -> ctx.source().map(c::test).orElse(false))));
    private static final Map<String, ParameterFactory<Context>> PARAMETERS = Map.ofEntries(Map.entry("player_effect", EffectParameter.factory().map(p -> p.map(Context::player))), Map.entry("damage", ParameterFactory.simple(ctx -> ctx.damage())));
    private final CalculationManager<Context> manager;

    private TakeDamageExperienceSource(CalculationManager<Context> calculated) {
        this.manager = calculated;
    }

    public static void register() {
        SkillsAPI.registerExperienceSourceWithData(ID, (json, context) -> json.getAsObject().andThen(rootObjet -> TakeDamageExperienceSource.create(rootObjet, context)));
    }

    private static Result<TakeDamageExperienceSource, Failure> create(JsonObjectWrapper rootObject, ConfigContext context) {
        return CalculationManager.create(rootObject, CONDITIONS, PARAMETERS, context).mapSuccess(TakeDamageExperienceSource::new);
    }

    public int getValue(ServerPlayer player, float damage, DamageSource damageSource) {
        return this.manager.getValue(new Context(player, damage, damageSource));
    }

    @Override
    public void dispose(MinecraftServer server) {
    }

    private record Context(ServerPlayer player, float damage, DamageSource damageSource) {
        String damageType() {
            return this.damageSource.m_19385_();
        }

        Optional<EntityType<?>> source() {
            return Optional.ofNullable(this.damageSource.m_7640_()).map(Entity::m_6095_);
        }

        Optional<EntityType<?>> attacker() {
            return Optional.ofNullable(this.damageSource.m_7639_()).map(Entity::m_6095_);
        }
    }
}

